/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryService
implements FcsService,
MCLErrorIds {
    private static final String TRACE_MASKD = "XMCLQRYD";
    private static final String TRACE_MASKF = "XMCLQRYF";
    private static final String TRACE_MASKT = "XMCLQRYT";
    public static final String QUERY_SERVICE_NAME = "com.ibm.hwmca.base.updates.QueryServiceToken";
    public static final double QUERY_SERVICE_VERSION = 1.0;
    private FcsConnection connection;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");

    public void processConnection(FcsConnection connection) {
        Trace.trace(TRACE_MASKT, "-> QueryService.processConnection()");
        this.connection = connection;
        this.process();
        Trace.trace(TRACE_MASKT, "<- QueryService.processConnection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void process() {
        block12: {
            Trace.trace(TRACE_MASKT, "-> QueryService.process()");
            ObjectOutputStream out = null;
            out = new ObjectOutputStream(new BufferedOutputStream(this.connection.getSocket().getOutputStream()));
            UpdateManager manager = UpdateManager.getUpdateManager();
            List streams = manager.getTowerUpdateableComponents();
            ArrayList<UpdateLevel> stagedUpdateLevels = new ArrayList<UpdateLevel>();
            Iterator counterOfStreams = streams.iterator();
            while (counterOfStreams.hasNext()) {
                UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
                int stagedLevel = nextUpdateableComponent.getStagedLevel();
                Trace.trace(TRACE_MASKD, "Component [" + nextUpdateableComponent.getECNumber() + "] stagedLevel=" + stagedLevel);
                UpdateLevel nextUpdateLevel = new UpdateLevel(nextUpdateableComponent.getECNumber(), stagedLevel);
                stagedUpdateLevels.add(nextUpdateLevel);
            }
            out.writeObject(stagedUpdateLevels);
            out.flush();
            Object var10_10 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block12;
            }
            catch (IOException ioe2) {}
            break block12;
            {
                catch (IOException ioe) {
                    this.logError("I/O error while processing query of update collections = " + ioe, (short)-3872, ioe);
                    Object var10_11 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block12;
                    }
                    catch (IOException ioe2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- QueryService.process()");
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        Trace.trace(TRACE_MASKD, "<- logError()");
    }
}

